SELECT TOP(500)
     	q.qreport_key 							as QREPORT_KEY,
     	o.accession_num 							as ACCESSION_NUM,
     	replace(convert(numeric, q.qreport_key),'.','') 				as ACCESSION_NUM1,
     	DEB_UTIL.GET_DATETIME() 						as TRIGGER_DTTM,
	Case o.extension7 When 'I'  Then 0  Else 1 End                                     as IO,
     	o.Extension8 			 				as VDATE,
     	o.Extension9 			 				as WNO,
     	o.Extension10 							as ONO,
     	p.patient_id 							as PATIENT_ID,
    	case  r.report_stat 
		When 4010 Then '230' 
		When 5010 Then '240' 
		When 6010 Then '250' 
		Else '230' 
    	End 								as REPORT_STAT,
    	(select user_id from tuser where user_key = r.read_doc_key ) 		as READ_DOC_ID,
    	(select user_name from tuser where user_key = r.read_doc_key ) 		as READ_DOC_NAME,
    	r.read_date 							as READ_DATE, 
    	(select user_id from tuser where user_key = r.confirm_doc_key ) 		as CONFIRM_DOC_ID,
    	(select user_name from tuser where user_key = r.confirm_doc_key ) 	as CONFIRM_DOC_NAME,
    	r.confirm_date 							as CONFIRM_DATE, 
    	(select user_id from tuser where user_key = r.addconfirm_doc_key ) 	as ADDCONFIRM_DOC_ID,
    	(select user_name from tuser where user_key = r.addconfirm_doc_key ) 	as ADDCONFIRM_DOC_NAME,
    	r.addconfirm_date 							as ADDCONFIRM_DATE,
    	REPLACE(T.REPORT_TEXT,CHAR(39),'`') 					as REPORT_TEXT ,  
    	REPLACE(T.conclusion,CHAR(39),'`') 					as CONCLUSION,
    	Concat('Reading : ' , char(10) , char(13) , REPLACE(T.REPORT_TEXT,CHAR(39),'`') , char(10) , char(13) , 'Conclusion : ' , char(10) , char(13) , REPLACE(T.conclusion,CHAR(39),'`'))	     as TOTAL_TEXT ,  
    	q.qreport_key 							as QREPORT_KEY1 
From 	tqreport q , tstudy s , treport r , treporttext t , tpatient p, torder o
Where 	q.flag = 'N'
And   	q.report_key = r.report_key
And   	r.study_key = s.study_key
And   	r.report_key = q.report_key
And   	t.report_text_key = ( select max(x.report_text_key) from treporttext x where x.report_key = r.report_key AND r.stat_flag = 'Y')
And   	s.patient_key = p.patient_key
And   	s.stat_flag = 'Y'
And   	r.stat_flag = 'Y'
And   	r.report_type='P'
And   	s.order_key is not null
And       o.order_key = s.order_key
And       o.patient_key = p.patient_key
